% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% HighResolutionLuminance.m


function HighResolutionLuminance(rgb)


%% Display Setup Module

% Define display parameters
if nargin < 1, rgb = [1 1 1]; end 
       % set the color channels to test
whichScreen = max(Screen('screens'));
p.ScreenGamma = 2;  % from monitor calibration
p.ScreenBackground = 0;

% Open display window and hide the mouse cursor
if exist('onCleanup', 'class'), ...
      oC_Obj = onCleanup(@()sca); end 
       % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General',  'FloatingPoint32BitIfPossible');   
        % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General',   'NormalizedHighresColorRange');
% Options for different hardware or software solutions.
% PsychImaging('AddTask', 'General',    'EnableNative10BitFramebuffer');
% PsychImaging('AddTask', 'General',    'EnablePseudoGrayOutput');
% PsychImaging('AddTask', 'General',   'EnableVideoSwitcherSimpleLuminanceOutput', 126.3);
% PsychImaging('AddTask', 'General',    'EnableDataPixxM16Output');
% PsychImaging('AddTask', 'General',    'EnableBits++Color++Output');
PsychImaging('AddTask', 'FinalFormatting',    'DisplayColorCorrection', 'SimpleGamma');
[windowPtr ScreenRect] = PsychImaging('OpenWindow',    whichScreen, p.ScreenBackground);
PsychColorCorrection('SetEncodingGamma', windowPtr,   1 / p.ScreenGamma);
HideCursor;
% Set screen font
Screen('TextFont', windowPtr, 'Times'); 
Screen('TextSize', windowPtr, 24);
% Control color channel by alpha blending
Screen('BlendFunction', windowPtr, 'GL_ONE', 'GL_ZERO', ...
      [rgb 1]);
Screen('Flip',windowPtr);

%% Experimental Module

% Make two textures, one 32-bit, the other 8-bit
n = ScreenRect(4) - 100;  % leave 100 pixel for instruction
                          % display
img = linspace(0, 1, n * 4)';
img = [img(1 : n) img((n : -1 : 1) + n) img((1 : n) + ...
      2 * n) img((n : -1 : 1) + 3 * n)];
m = floor(ScreenRect(3) / 4);
img = Expand(img, m, 1);
tex(1) = Screen('MakeTexture', windowPtr, img, [], [], 2);   
                          % 32-bit
tex(2) = Screen('MakeTexture', windowPtr, uint8(img * ...
                255));    % 8-bit
dstRect=[0 100 m*4 ScreenRect(4)];
txt1 = sprintf('ESC to exit. Space to toggle. Gamma %.2g\n\n', p.ScreenGamma);
% Show the ramp
highBit = 0;
while 1
    if highBit, txt2 = ' Maximum bits';
    else txt2 = ' 8 bits';
    end
    % Draw the 32- or 8-bit texture
    Screen('DrawTexture', windowPtr, tex(2 - highBit), ...
           [], dstRect, [], 0);
    DrawFormattedText(windowPtr, [txt1 txt2], 30, 0, 1); 
                          % instruction
    Screen('Flip', windowPtr);
    
    % Wait for space or esc
    key = WaitTill({'space' 'esc'});
   
    if strcmp(key, 'esc')
        break;
    else
        highBit = 1 - highBit; % toggle between the 32- 
                               % and 8-bit textures
        KbReleaseWait;
    end
end

%% System Reinstatement Module
sca; % close window and textures, 
     % restore color lookup table

